library(mvtnorm) 
library(tibble)     
library(dplyr)      
library(tidyr)      
library(ggplot2) 
library(cowplot)

N=1000
n=500000
d=5


Sigma=diag(1,5)
xt=seq(0,1,0.25)

grad_comp = function(x_old, a_new, b_new, type = "Linear"){
  if (type == "Linear"){
    grad = t(a_new)*c(a_new%*%x_old - b_new)
  }else{
    grad = -b_new*t(a_new)/c(1+exp(b_new*a_new%*%x_old))
  }
  return (grad)
}


generate_data_log = function(n,d, x_true){
  
  logis=matrix(0,d+1,n)
  for(i in 1:n){
    a = rt(d,3,0)
    p = 1/c(1+exp(-a%*%x_true)) 
    b = 2*rbinom(1, 1, p)-1
    logis[,i]=c(b,a)
  }
  
  
  return(logis)
}


iterate=function(M,alpha){
  n=dim(M)[2]
  d=dim(M)[1]-1
  X=matrix(0,d,n)
  X[,1]=rep(0,d)
  for(i in 2:n){
    X[,i]=X[,i-1]-alpha*grad_comp(X[,i-1],M[-1,i],M[1,i]
                                  ,type = "Logistic")
  }
  return(X)
}



############Generate Data################
datalg=list()

for(j in 1:N){
  set.seed(j)
  datalg[[j]]=generate_data_log(n,d,xt)
}


#############SGD iterate###############

alpha=0.005

ite005=list()

for(j in 1:N){
  ite005[[j]]=iterate(datalg[[j]],alpha)
}

sgd_last005=matrix(0,d,N)
for(i in 1:N){
  sgd_last005[,i]=ite005[[i]][,n]
  
}




alpha=0.001

ite001=list()

for(j in 1:N){
  ite001[[j]]=iterate(datalg[[j]],alpha)
}

sgd_last001=matrix(0,d,N)
for(i in 1:N){
  sgd_last001[,i]=ite001[[i]][,n]
  
}

  
alpha=0.0002

  
ite0002=list()

for(j in 1:N){
  ite0002[[j]]=iterate(datalg[[j]],alpha)
}


sgd_last0002=matrix(0,d,N)
for(i in 1:N){
  sgd_last0002[,i]=ite0002[[i]][,n]
  
}
  
##########Plot################


p=3

eps = seq(0.001,1,0.001)


plot_Nagaev=function(yu, xu,eps,sgd,xt,N,p,alpha){
  
  prob = rep(0, length(eps))
  for ( i in 1:length(eps)){
    prob[i] = sum(abs(sgd-xt)>eps[i])/5/N*eps[i]^p
  }
  subG=2*exp(-2*eps^2/alpha)*eps^p
  df <- tibble(x = eps , y1 = rep(alpha^(p/2),length(eps)), y2 = subG+alpha^(p-1), 
               y3 = prob) %>% pivot_longer(cols = starts_with("y"), 
                                           names_to = "series", values_to = "value")
  custom_labels <- c("y1" = "Markov", "y2" = "Nagaev", "y3" = "Empirical Probability")
  p1 <- ggplot(df, aes(x = x, y = value, color = series)) +
    geom_line(size = 1) +
    scale_color_manual(
      values = c("y1" = "green", "y2" = "red", "y3" = "black"),
      labels = custom_labels,
      name = NULL 
    ) +
    labs(x = "", y = '',
         color = "Series") +
    xlim(0, xu) +                # Set x-axis limits
    ylim(0, yu) +
    theme(legend.position = "none",
          legend.direction = "horizontal",
          legend.text = element_text(size = 12))
  return(p1)
}

p1 <- plot_Nagaev(0.0005, 1, eps, sgd_last005, xt, N, p, 0.005)
p2 <- plot_Nagaev(0.00005, 0.2, eps, sgd_last001, xt, N, p, 0.001)
p3 <- plot_Nagaev(0.000005, 0.1, eps, sgd_last0002, xt, N, p, 0.0002)

plots_row <- plot_grid(p1, p2, p3, nrow = 1)
plots_row


